// JavaScript to use within the GeckoView extension
// For App Builders 10.1 and above

// Establish connection with app
let port = browser.runtime.connectNative("browser");

let prevFunction = null;
let prevTime = 0;

port.onMessage.addListener(response => {

    // Define event listener
    // This allows us to receive messages back from the web page
    window.addEventListener('message', function(event) {
        if (event.data.type == 'js-function') {
            var thisFunction = event.data.text;
            var callFunction = false;

            if (prevFunction !== thisFunction) {
               // Function is different from the previous one, so we want to call it
               callFunction = true;
            }
            else if ((new Date() - prevTime) > 500) {
                // Function is the same as last time, but more than half a second later, so call it.
                // We need to check this because we were getting the same function being called multiple times.
                callFunction = true;
            }

            if (callFunction) {
                port.postMessage("JS:" + thisFunction);
                prevFunction = thisFunction;
                prevTime     = new Date();
            }
        }
    });

    // We need to inject the JavaScript code into the web page and run it
    // https://stackoverflow.com/questions/9515704/use-a-content-script-to-access-the-page-context-variables-and-functions/9517879#9517879
    var script = document.createElement('script');
    script.textContent = response.jsCode;
    (document.head||document.documentElement).appendChild(script);
    script.remove();
});

port.postMessage("Connected to App Builders web extension");